#include <iostream>
#include <cstdlib>
#include <cmath>
#include <vector>
#include <map>
#include <set>
#include <queue>
#include <ctime>
#include <cassert>
#include <string>
#include <cstdlib>
#include <cstring>
#include <algorithm>
#include <memory.h>

using namespace std;

const int N = 66;
const int INF = 1e9;

int n, a[N][N], pred[N];
vector<pair<int, pair<int, int>>>  v;
vector<pair<int, int>> g[N];
int used[N];

int fs(int x) {
	if (pred[x] != x) pred[x] = fs(pred[x]);
	return pred[x];
}

bool cmp(pair<int, pair<int, int>> u, pair<int, pair<int, int>> v) {
	return u > v;
}

int go(int x, int y, int t) {
	if (x == y) return t;
	used[x] = true;
	int res = INF;
	for (int i = 0; i < g[x].size(); i++) {
		int e = g[x][i].first;
		if (!used[e]) res = min(res, go(e, y, min(t, g[x][i].second)));
	}
	return res;
}

int main() {
	freopen("input.txt", "r", stdin);
	scanf("%d", &n);
	for (int i = 0; i < n; i++) {
		for (int j = 0; j < n; j++) {
			scanf("%d", &a[i][j]);
			if (i != j) {
				v.push_back(make_pair(a[i][j], make_pair(i, j)));
			}
		}
	}
	sort(v.begin(), v.end(), cmp);
	for (int i = 0; i < n; i++) pred[i] = i;
	vector<pair<pair<int, int>, int>> ans;
	for (int i = 0; i < v.size(); i++) {
		int x = fs(v[i].second.first);
		int y = fs(v[i].second.second);
		if (x == y) continue;
		pred[x] = y;
		x = v[i].second.first;
		y = v[i].second.second;
		ans.push_back(make_pair(make_pair(x, y), v[i].first));
		g[x].push_back(make_pair(y, v[i].first));
		g[y].push_back(make_pair(x, v[i].first));
	}
	for (int i = 0; i < n; i++) {
		for (int j = 0; j < n; j++) {
			if (i == j) continue;
			memset(used, false, sizeof(used));
			int cur = go(i, j, INF);
			if (cur != a[i][j]) {
				puts("NO");
				return 0;
                        }
		}
	}
	puts("YES");
	printf("%d\n", n - 1);
	for (int i = 0; i + 1 < n; i++) {
		printf("%d %d %d\n", ans[i].first.first + 1, ans[i].first.second + 1, ans[i].second);
	}
}